/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpEngine;

import ibm.nways.analysis.dpEngine.DpInterfaceImpl;
import ibm.nways.analysis.dpEngine.DpeCounters;
import ibm.nways.analysis.dpEngine.DpeStats;
import ibm.nways.analysis.dpEngine.NodeStats;
import ibm.nways.jdm.snmp.FullSnmpStats;
import ibm.nways.jdm.snmp.PollingIntervalAction;
import ibm.nways.jdm.snmp.SnmpAPI;
import ibm.nways.jdm.snmp.SnmpSession;
import ibm.nways.jdm.snmp.SnmpStatistics;
import ibm.nways.jdm.snmp.SwadeohPoller;
import java.util.Vector;

public class Monitor
extends Thread
implements PollingIntervalAction {
    private DpInterfaceImpl dpe;
    private FullSnmpStats lastStats;
    private long totalPollingInterval;
    private long totalStartDelay;
    private long totalWorkingTime;
    private long totalExprAndStoreTime;
    private float totalNumOIs;
    private float totalNumPDUs;
    private long numIntervals;

    public long getAveragePollingInterval() {
        try {
            return this.totalPollingInterval / this.numIntervals;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public long getAverageStartDelay() {
        try {
            return this.totalStartDelay / this.numIntervals;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public long getAverageTotalTime() {
        try {
            return this.totalWorkingTime / this.numIntervals;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public long getAverageExprAndStoreTime() {
        try {
            return this.totalExprAndStoreTime / this.numIntervals;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public float getAverageNumOIs() {
        try {
            return this.totalNumOIs / (float)this.numIntervals;
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public float getAverageNumPDUs() {
        try {
            return this.totalNumPDUs / (float)this.numIntervals;
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    protected Monitor(DpInterfaceImpl dpInterfaceImpl) {
        this.dpe = dpInterfaceImpl;
    }

    public void run() {
        while (true) {
            Monitor monitor = this;
            synchronized (monitor) {
                try {
                    this.wait(60000L);
                }
                catch (InterruptedException interruptedException) {}
                if (DpInterfaceImpl.trace) {
                    DpInterfaceImpl.LogMessage(this.getStats(false).toString());
                    DpInterfaceImpl.LogMessage("Information for all nodes being polled:");
                    DpInterfaceImpl.LogMessage(DpInterfaceImpl.nodeList.toString());
                }
                DpInterfaceImpl.sendStatisticsEvent(this.getStats(true));
            }
        }
    }

    public DpeStats getStats(boolean bl) {
        Object object;
        Object object2;
        Vector<FullSnmpStats> vector = new Vector<FullSnmpStats>();
        Vector vector2 = this.dpe.getExceededNodes();
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            object2 = (SnmpSession)vector2.elementAt(n2);
            SnmpStatistics snmpStatistics = object2.getSnmpStats();
            FullSnmpStats fullSnmpStats = snmpStatistics.getStats();
            object = new NodeStats(object2.getIpAddress(), fullSnmpStats.minRspTime, fullSnmpStats.maxRspTime, fullSnmpStats.timeouts, fullSnmpStats.sends, fullSnmpStats.retries);
            vector.addElement((FullSnmpStats)object);
            ++n2;
        }
        object = SnmpAPI.getSnmpStats().getStats();
        object2 = this.dpe.getCounters(bl);
        DpeStats dpeStats = new DpeStats(this.dpe.getLocalHostName(), System.currentTimeMillis(), (FullSnmpStats)object, bl ? this.lastStats : null, this.dpe.getIntervalsMatched(), vector, Runtime.getRuntime().totalMemory(), Runtime.getRuntime().freeMemory(), (DpeCounters)object2, bl);
        if (bl) {
            this.lastStats = object;
            Monitor monitor = this;
            synchronized (monitor) {
                this.totalPollingInterval = 0L;
                this.totalStartDelay = 0L;
                this.totalWorkingTime = 0L;
                this.totalExprAndStoreTime = 0L;
                this.totalNumOIs = 0.0f;
                this.totalNumPDUs = 0.0f;
                this.numIntervals = 0L;
            }
        }
        DpInterfaceImpl.lastNotifiedLevel = DpInterfaceImpl.intervalsMatched;
        return dpeStats;
    }

    public synchronized void intervalCompleted(Object object, long l) {
        SwadeohPoller swadeohPoller = (SwadeohPoller)object;
        if (DpInterfaceImpl.trace) {
            System.out.println("Made it to the intervalCompleted callback");
            System.out.println("   Polling interval = " + swadeohPoller.getInterval());
            System.out.println("   Total time       = " + (swadeohPoller.pseudosDoneTime - swadeohPoller.scheduledStartTime));
            System.out.println("     Start delay    = " + (swadeohPoller.actualStartTime - swadeohPoller.scheduledStartTime));
            System.out.println("     Build PDUs     = " + (swadeohPoller.pdusBuiltTime - swadeohPoller.actualStartTime));
            System.out.println("     Send/recv      = " + (swadeohPoller.pdusReceivedTime - swadeohPoller.pdusBuiltTime));
            System.out.println("     Extract data   = " + (swadeohPoller.dataExtractedTime - swadeohPoller.pdusReceivedTime));
            System.out.println("     Second round   = " + (swadeohPoller.secondRoundTime - swadeohPoller.dataExtractedTime));
            System.out.println("     Pollers        = " + (swadeohPoller.pollersDoneTime - swadeohPoller.secondRoundTime));
            System.out.println("     Pseudos        = " + (swadeohPoller.pseudosDoneTime - swadeohPoller.pollersDoneTime));
            System.out.println("  Number of OIDs    = " + swadeohPoller.numOIDs);
            System.out.println("  Number of PDUs    = " + swadeohPoller.numPDUs);
            System.out.println("  Deviants          = " + swadeohPoller.numDeviants);
        }
        this.totalPollingInterval += (long)swadeohPoller.getInterval();
        this.totalStartDelay += swadeohPoller.actualStartTime - swadeohPoller.scheduledStartTime;
        this.totalWorkingTime += swadeohPoller.pseudosDoneTime - swadeohPoller.actualStartTime;
        this.totalExprAndStoreTime += swadeohPoller.pollersDoneTime - swadeohPoller.secondRoundTime;
        this.totalNumOIs += (float)swadeohPoller.numOIDs;
        this.totalNumPDUs += (float)swadeohPoller.numPDUs;
        ++this.numIntervals;
    }
}

